<?php
namespace ModulesGarden\DomainsReseller\App\UI\Admin\Groups\Forms\Tld\Sections\Pricing;

use ModulesGarden\DomainsReseller\App\Libs\Repositories\Whmcs\Pricing;
use ModulesGarden\DomainsReseller\App\Libs\Resources\Whmcs\Currencies\Currency;
use ModulesGarden\DomainsReseller\App\UI\Admin\Groups\Fields\PricingField;
use ModulesGarden\DomainsReseller\App\UI\Admin\Groups\Forms\Traits\LoadDataToForm;
use ModulesGarden\DomainsReseller\Core\UI\Widget\Forms\Sections\HiddenPricingSection;


/**
 * Description of PricingFields
 *
 * @author Paweł Złamaniec <pawel.zl@modulesgarden.com>
 */
class PricingRow extends HiddenPricingSection
{
    use LoadDataToForm;

    /**
     * @var Currency
     */
    protected $currency;

    public function initContent()
    {
        foreach(Pricing::DOMAIN_TYPES as $type)
        {
            $disabledValue = ($type === Pricing::TYPE_DOMAIN_REGISTER) ? -1 : 0;
            $field = new PricingField();

            $field->initIds("{$this->getCurrencyCode()}[{$type}][{$this->getFieldName()}]")
                    ->setPrefix($this->getCurrency()->prefix)
                    ->setDecimal()
                    ->setPricingMinimalValues(0, $disabledValue)
                    ->setTitle($type);
            $this->addField($field);
        }
    }

    /**
     *
     * @return mixed
     */
    protected function getCurrencyCode()
    {
        $parts = explode("_", $this->getId());

        return $parts[1];
    }

    /**
     * @return mixed
     */
    protected function getFieldName()
    {
        $parts = explode("_", $this->getId());

        return $parts[0];
    }

    /**
     * @return Currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param Currency $currency
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;

        return $this;
    }
}
