<?php

namespace ModulesGarden\DomainsReseller\App\UI\Admin\Groups\Forms\Tld\Sections\Pricing;

use ModulesGarden\DomainsReseller\App\UI\Admin\Groups\Forms\Traits\LoadDataToForm;
use \ModulesGarden\DomainsReseller\Core\UI\Widget\Forms\Sections\TabSection;
use \ModulesGarden\DomainsReseller\App\Libs\Repositories\Whmcs\Pricing;
use ModulesGarden\DomainsReseller\App\Libs\Resources\Whmcs\Currencies\Currency;

/**
 * Description of CurrencyTab
 *
 * @author Paweł Złamaniec <pawel.zl@modulesgarden.com>
 */
class CurrencyTab extends TabSection
{
    use LoadDataToForm;

    /**
     * @var Currency
     */
    private $currency;

    public function initContent()
    {
        $this->setRawTitle($this->getTitle());
        $this->generatePricing();
    }

    /**
     * Generate Pricing Tabs
     */
    public function generatePricing()
    {
        foreach(Pricing::DOMAIN_FIELDS as $field)
        {
            $section = new PricingRow($field);
            $section->setId("{$field}_{$this->getId()}")
                ->setCurrency($this->getCurrency())
                ->setMainContainer($this->mainContainer);

            $this->addSection($section);
        }
    }

    /**
     * @return Currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param Currency $currency
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
    }


}
